<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:template match="/effect">
		<html>
			<head>
			<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1"/>
			<link rel="stylesheet" href="expandAll.css"/>
			</head>
			<body>
				<h1><xsl:value-of select="@name"/></h1><xsl:value-of select="@description"/>
				<h2>Parameters</h2>
				<div style="margin-left:3em">
				<table border="0" cellspacing="3" >						
					<tr>
						<th>Name</th>
						<th>Description</th>
						<th>Type</th>
						<th>Default</th>
					</tr>				
					<xsl:apply-templates select="value"/>	
				</table>					
				</div>					

				<h2>Splines</h2>
				<div style="margin-left:3em">
				<table border="0" cellspacing="3" >										
					<tr>
						<th>Name</th>
						<th>Description</th>
						<th>Default</th>
					</tr>				
					<xsl:apply-templates select="var"/>	
				</table>					
				</div>	


<p><br/>
  <br/>
</p>
<hr/>
<font size="2" color="#333333">Note: all effects have the following parameters</font><br/>
<table border="0" cellspacing="3" >
  <tr> 
    <th><font size="2" color="#333333">Name</font></th>
    <th><font size="2" color="#333333">Description</font></th>
    <th><font size="2" color="#333333">Type</font></th>
    <th><font size="2" color="#333333">Default</font></th>
  </tr>
<!--
  <tr> 
    <td><font size="2" color="#333333"><b>visible</b></font></td>
    <td><font size="2" color="#333333">if 0, then the effect is invisible otherwise visible</font></td>
    <td><font size="2" color="#333333"><b>int</b></font></td>
    <td><font size="2" color="#333333">1</font></td>
  </tr>
-->
  <tr> 
    <td><font size="2" color="#333333"><b>blendEnable</b></font></td>
    <td><font size="2" color="#333333">if 1, then blending is enabled using the 
      other blending parameters. if blendSrc or blendDst is set then this is enabled</font></td>
    <td><font size="2" color="#333333"><b>int</b></font></td>
    <td><font size="2" color="#333333">-1</font></td>
  </tr>
  <tr> 
    <td><font size="2" color="#333333"><b>blendSrc</b></font></td>
    <td><font size="2" color="#333333">gl blending source, see opengl docs. e.g. 
      "blendSrc = GL_SRC_ALPHA;"</font></td>
    <td><font size="2" color="#333333"><b>int</b></font></td>
    <td><font size="2" color="#333333">-1</font></td>
  </tr>
  <tr> 
    <td><font size="2" color="#333333"><b>blendDst</b></font></td>
    <td><font size="2" color="#333333">gl blending destination, see opengl docs. 
      e.g. "blendDst = GL_ONE;"</font></td>
    <td><font size="2" color="#333333"><b>int</b></font></td>
    <td><font size="2" color="#333333">-1</font></td>
  </tr>
  <tr> 
    <td><font size="2" color="#333333"><b>blendEq</b></font></td>
    <td><font size="2" color="#333333">gl blending equation, see opengl docs</font></td>
    <td><font size="2" color="#333333"><b>int</b></font></td>
    <td><font size="2" color="#333333">-1</font></td>
  </tr>
  <tr> 
    <td><font size="2" color="#333333"><b>blendCol</b></font></td>
    <td><font size="2" color="#333333">gl blending color, see opengl docs</font></td>
    <td><font size="2" color="#333333"><b>array4</b></font></td>
    <td><font size="2" color="#333333">-1,-1,-1,-1</font></td>
  </tr>
</table>

				
			</body>
		</html>
	</xsl:template>

	<xsl:template match="value|var">
		<tr>
			<td><b><xsl:value-of select="@name"/></b></td>
			<td><xsl:value-of select="@description"/></td> 
			<td><b><xsl:value-of select="@type"/></b></td> 
			<td><xsl:value-of select="@default"/></td> 
		</tr>
	</xsl:template>

	<xsl:template match="var">
		<tr>
			<td><b><xsl:value-of select="@name"/></b></td>
			<td><xsl:value-of select="@description"/></td> 
			<td><xsl:value-of select="@default"/></td> 
		</tr>
	</xsl:template>
</xsl:stylesheet>
